<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PassageVeterinaireVague extends Model 
{

    protected $table = 'passages_veterinaires_vagues';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'statut', 'id_passage_veterinaire', 'id_vague');
    protected $visible = array('slug', 'statut', 'id_passage_veterinaire', 'id_vague');

    public function passageVeterinaire()
    {
        return $this->belongsTo('App\Models\PassageVeterinaire', 'id_passage_veterinaire');
    }

    public function vague()
    {
        return $this->belongsTo('App\Models\Vague', 'id_vague');
    }

}